<?php
/**
 * AiPress Chat — Loader component.
 *
 * @package aiPress_Chat
 * @since   0.1.0
 */

namespace AIPress;

/**
 * Loader component.
 *
 * @package aiPress_Chat
 * @since   0.1.0
 */
class Loader {
	/**
	 * Private component.
	 *
	 * @var inst $inst.
	 */
	private static $inst;
	/**
	 * Instance component.
	 *
	 * @package aiPress_Chat
	 * @since   0.1.0
	 */
	public static function instance() {
		if ( ! self::$inst ) {
			self::$inst = new self();
		}
		return self::$inst;
	}
	/**
	 * Construct component.
	 *
	 * @package aiPress_Chat
	 * @since   0.1.0
	 */
	private function __construct() {
		// simple autoloader.
		spl_autoload_register(
			function ( $cls ) {
				if ( ! str_starts_with( $cls, __NAMESPACE__ . '\\' ) ) {
					return;
				}
				$relative = substr( $cls, strlen( __NAMESPACE__ . '\\' ) );
				$parts    = explode( '\\', $relative );
				$basename = array_pop( $parts );
				$filename = 'class-' . strtolower( $basename ) . '.php';
				$filepath = AIPRESS_PATH . '/includes/' . $filename;

				if ( file_exists( $filepath ) ) {
					require $filepath;
				}
			}
		);

		new Admin\Settings();
		new Indexer();
		new Chat();
	}
}

require_once AIPRESS_PATH . '/includes/class-conversation-logs.php';