// Admin JavaScript for aiPress Chat
jQuery(document).ready(function($) {
    console.log('aiPress admin.js loaded');
    
    // Initialize chat modal functionality
    initializeChatModal();
});

// Add modal HTML to page
function initializeChatModal() {
    // Only run on the logs page
    if (!document.querySelector('.view-chat-btn')) {
        return;
    }
    
    console.log('Initializing chat modal...');
    
    const modalHTML = `
        <div id="chatModal" class="chat-modal">
            <div class="chat-modal-content">
                <div class="chat-modal-header">
                    <h2 id="chatModalTitle">Conversation Details</h2>
                    <span class="chat-modal-close">&times;</span>
                </div>
                <div id="chatModalBody">
                    Loading conversation...
                </div>
            </div>
        </div>
    `;
    document.body.insertAdjacentHTML('beforeend', modalHTML);
    
    // Add event listeners
    const modal = document.getElementById('chatModal');
    const closeBtn = document.querySelector('.chat-modal-close');
    
    // Close modal events
    closeBtn.onclick = () => {
        console.log('Close button clicked');
        modal.style.display = 'none';
    };
    
    window.onclick = (event) => {
        if (event.target === modal) {
            console.log('Modal backdrop clicked');
            modal.style.display = 'none';
        }
    };
    
    // View chat button events
    document.addEventListener('click', function(e) {
        if (e.target.classList.contains('view-chat-btn')) {
            e.preventDefault();
            console.log('View chat button clicked');
            const conversationId = e.target.dataset.conversationId;
            const conversationDate = e.target.dataset.conversationDate;
            showChatModal(conversationId, conversationDate);
        }
    });
}

// Show the modal with conversation data
function showChatModal(conversationId, conversationDate) {
    console.log('Showing modal for conversation:', conversationId);
    
    const modal = document.getElementById('chatModal');
    const title = document.getElementById('chatModalTitle');
    const body = document.getElementById('chatModalBody');
    
    title.textContent = `Conversation from ${conversationDate}`;
    body.innerHTML = 'Loading conversation...';
    modal.style.display = 'block';
    
    // Fetch conversation data via AJAX
    jQuery.post(ajaxurl, {
        action: 'get_conversation_details',
        conversation_id: conversationId
    })
    .done(function(response) {
        console.log('AJAX response:', response);
        if (response.success) {
            body.innerHTML = response.data;
        } else {
            body.innerHTML = 'Error loading conversation: ' + (response.data || 'Unknown error');
        }
    })
    .fail(function() {
        console.log('AJAX request failed');
        body.innerHTML = 'Network error loading conversation.';
    });
}