<?php
/**
 * Run once when the plugin is deleted from the Plugins screen.
 * IMPORTANT: fires only on actual deletion, not on deactivate/activate.
 * @package aiPress_Chat
 */
if ( ! defined( 'WP_UNINSTALL_PLUGIN' ) ) {
	exit;
}

global $wpdb;

/* 1. drop embedding table */
$table = $wpdb->prefix . 'aipress_chunks';
$wpdb->query( "DROP TABLE IF EXISTS `" . esc_sql( $table ) . "`" );

/* 2. delete stored options */
delete_option( 'aipress_settings' );
delete_option( 'aipress_last_indexed' );

/* 3. clear throttling transients */
$transients = $wpdb->get_col(
	$wpdb->prepare(
		"SELECT option_name FROM {$wpdb->options}
		 WHERE option_name LIKE %s",
		$wpdb->esc_like( '_transient_apc_' ) . '%'
	)
);
foreach ( $transients as $name ) {
	delete_option( $name );                 // raw option name holds the transient
	delete_option( str_replace( '_transient_', '_transient_timeout_', $name ) );
}
